/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DriverJDBCVersion;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SQLServerResultSetMetaData
implements ResultSetMetaData {
    private SQLServerConnection con;
    private SQLServerResultSet rs;
    public int nBeforeExecuteCols;
    private static final Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.SQLServerResultSetMetaData");
    private static int baseID = 0;
    private final int instanceID = SQLServerResultSetMetaData.nextInstanceID();

    private static synchronized int nextInstanceID() {
        return ++baseID;
    }

    public final String toString() {
        String string = " SQLServerResultSetMetaData:" + this.instanceID;
        return string;
    }

    public SQLServerResultSetMetaData(SQLServerConnection sQLServerConnection, SQLServerResultSet sQLServerResultSet) {
        this.con = sQLServerConnection;
        this.rs = sQLServerResultSet;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toString() + " created by (" + sQLServerResultSet.toString() + ")");
        }
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
    }

    @Override
    public String getCatalogName(int n) throws SQLServerException {
        return this.rs.getColumn(n).getTableName().getDatabaseName();
    }

    @Override
    public int getColumnCount() throws SQLServerException {
        if (this.rs == null) {
            return 0;
        }
        return this.rs.getColumnCount();
    }

    @Override
    public int getColumnDisplaySize(int n) throws SQLServerException {
        TypeInfo typeInfo = this.rs.getColumn(n).getTypeInfo();
        int n2 = typeInfo.getPrecision();
        switch (typeInfo.getSSType()) {
            case TINYINT: 
            case BIT: 
            case DATETIME: 
            case SMALLDATETIME: 
            case VARCHAR: 
            case VARCHARMAX: 
            case CHAR: 
            case TEXT: 
            case NVARCHAR: 
            case NVARCHARMAX: 
            case NCHAR: 
            case NTEXT: 
            case GUID: 
            case XML: {
                break;
            }
            case BINARY: 
            case VARBINARY: 
            case VARBINARYMAX: 
            case IMAGE: 
            case TIMESTAMP: 
            case UDT: {
                if (n2 < 0x3FFFFFFF) {
                    n2 = 2 * n2;
                    break;
                }
                n2 = Integer.MAX_VALUE;
                break;
            }
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                if (n2 <= 3) break;
                ++n2;
                break;
            }
            case DECIMAL: 
            case NUMERIC: 
            case MONEY: 
            case SMALLMONEY: {
                n2 += 2;
                break;
            }
            case REAL: 
            case FLOAT: {
                if (7 == n2) {
                    n2 = 13;
                    break;
                }
                n2 = 22;
                break;
            }
            default: {
                assert (false) : "Unknown display size";
                break;
            }
        }
        return n2;
    }

    @Override
    public String getColumnLabel(int n) throws SQLServerException {
        return this.rs.getColumn(n).getColumnName();
    }

    @Override
    public String getColumnName(int n) throws SQLServerException {
        return this.rs.getColumn(n).getColumnName();
    }

    @Override
    public int getColumnType(int n) throws SQLServerException {
        return this.rs.getColumn(n).getTypeInfo().getSSType().getJDBCType().asJavaSqlType();
    }

    @Override
    public String getColumnTypeName(int n) throws SQLServerException {
        return this.rs.getColumn(n).getTypeInfo().getSSTypeName();
    }

    @Override
    public int getPrecision(int n) throws SQLServerException {
        return this.rs.getColumn(n).getTypeInfo().getPrecision();
    }

    @Override
    public int getScale(int n) throws SQLServerException {
        return this.rs.getColumn(n).getTypeInfo().getScale();
    }

    @Override
    public String getSchemaName(int n) throws SQLServerException {
        return this.rs.getColumn(n).getTableName().getSchemaName();
    }

    @Override
    public String getTableName(int n) throws SQLServerException {
        return this.rs.getColumn(n).getTableName().getObjectName();
    }

    @Override
    public boolean isAutoIncrement(int n) throws SQLServerException {
        return this.rs.getColumn(n).getTypeInfo().isIdentity();
    }

    @Override
    public boolean isCaseSensitive(int n) throws SQLServerException {
        return this.rs.getColumn(n).getTypeInfo().isCaseSensitive();
    }

    @Override
    public boolean isCurrency(int n) throws SQLServerException {
        SSType sSType = this.rs.getColumn(n).getTypeInfo().getSSType();
        return SSType.MONEY == sSType || SSType.SMALLMONEY == sSType;
    }

    @Override
    public boolean isDefinitelyWritable(int n) throws SQLServerException {
        return TypeInfo.UPDATABLE_READ_WRITE == this.rs.getColumn(n).getTypeInfo().getUpdatability();
    }

    @Override
    public int isNullable(int n) throws SQLServerException {
        return this.rs.getColumn(n).getTypeInfo().isNullable() ? 1 : 0;
    }

    @Override
    public boolean isReadOnly(int n) throws SQLServerException {
        return TypeInfo.UPDATABLE_READ_ONLY == this.rs.getColumn(n).getTypeInfo().getUpdatability();
    }

    @Override
    public boolean isSearchable(int n) throws SQLServerException {
        switch (this.rs.getColumn(n).getTypeInfo().getSSType()) {
            case TEXT: 
            case NTEXT: 
            case XML: 
            case IMAGE: 
            case UDT: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isSigned(int n) throws SQLServerException {
        return this.rs.getColumn(n).getTypeInfo().getSSType().getJDBCType().isSigned();
    }

    @Override
    public boolean isWritable(int n) throws SQLServerException {
        int n2 = this.rs.getColumn(n).getTypeInfo().getUpdatability();
        return TypeInfo.UPDATABLE_READ_WRITE == n2 || TypeInfo.UPDATABLE_UNKNOWN == n2;
    }

    @Override
    public String getColumnClassName(int n) throws SQLServerException {
        return this.rs.getColumn(n).getTypeInfo().getSSType().getJDBCType().className();
    }
}

